/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWActionType;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWEventDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public final class VWWFEInstruction
extends VWInstructionDefinition
implements Serializable {
    private static final long serialVersionUID = 7461L;
    private VWEventDefinition[] events = null;
    private VWArrayHandler eventsHandler = new VWArrayHandler(5, 5);
    private String timeOut = "0";
    private String eventNumLoc = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-19 01:21:56 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/5 $";
    }

    protected VWWFEInstruction() throws VWException {
    }

    protected VWWFEInstruction(VWCompoundStepDefinition step, int theInstructionId, String theTimeOut, String theEventNumLocation) throws VWException {
        super(step, theInstructionId, 19);
        this.setTimeOut(theTimeOut);
        this.setEventNumLoc(theEventNumLocation);
    }

    public String getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(String theTimeOut) throws VWException {
        if (theTimeOut == null) {
            throw new VWException("vw.api.VWWFEInstructionNullTimeOut", "theTimeOut parameter cannot be null.");
        }
        this.timeOut = theTimeOut;
    }

    public String getEventNumLoc() {
        return this.eventNumLoc;
    }

    public void setEventNumLoc(String theEventNumLoc) throws VWException {
        if (theEventNumLoc == null) {
            throw new VWException("vw.api.VWWFEInstructionNullEventNumLoc", "theEventNumLoc parameter cannot be null.");
        }
        this.eventNumLoc = theEventNumLoc;
    }

    public VWEventDefinition[] getEvents() throws VWException {
        return (VWEventDefinition[])this.eventsHandler.getElements(this.events);
    }

    public void setEvents(VWEventDefinition[] theEvents) throws VWException {
        int arrayLen;
        int n = arrayLen = theEvents != null ? theEvents.length : 0;
        if (theEvents != null) {
            for (int i = 0; i < arrayLen; ++i) {
                if (theEvents[i] != null) continue;
                throw new VWException("vw.api.VWWFEInstructionNullElementInEventArray", "theEvents contains a null element at index{0}.", String.valueOf(i));
            }
        }
        this.events = theEvents;
        this.eventsHandler.setElementCount(arrayLen);
    }

    protected VWEventDefinition createEvent() throws VWException {
        VWEventDefinition newEvent = new VWEventDefinition();
        this.events = (VWEventDefinition[])this.eventsHandler.addElementToArray(this.events, newEvent);
        return newEvent;
    }

    public VWEventDefinition createEvent(String theWCName, String theOperator, String theValue) throws VWException {
        VWEventDefinition newEvent = new VWEventDefinition(this, theWCName, theOperator, theValue);
        this.events = (VWEventDefinition[])this.eventsHandler.addElementToArray(this.events, newEvent);
        return newEvent;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWFEInstructionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t\t<WFEInstruction\n");
        theBuffer.append(ATTRIB_INDENT + "Id=\"" + Integer.toString(this.getInstructionId()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Action=\"" + VWActionType.typeToString(this.getAction()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "TimeOut=\"" + VWXMLHandler.toXMLString(this.timeOut) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "EventNumLoc=\"" + VWXMLHandler.toXMLString(this.eventNumLoc) + "\"");
        theBuffer.append(">\n");
        VWEventDefinition[] eventArray = this.getEvents();
        if (eventArray != null) {
            for (int i = 0; i < eventArray.length; ++i) {
                eventArray[i].toXML(theBuffer);
            }
        }
        theBuffer.append("\t\t\t</WFEInstruction>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWFEInstructionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        theBuffer.append(indentA + "<WFEInstruction\n");
        theBuffer.append(indentB + "Id=\"" + Integer.toString(this.getInstructionId()) + "\"\n");
        theBuffer.append(indentB + "Action=\"" + VWActionType.typeToString(this.getAction()) + "\"\n");
        theBuffer.append(indentB + "TimeOut=\"" + VWXMLHandler.toXMLString(this.timeOut) + "\"\n");
        theBuffer.append(indentB + "EventNumLoc=\"" + VWXMLHandler.toXMLString(this.eventNumLoc) + "\"");
        theBuffer.append(">\n");
        VWEventDefinition[] eventArray = this.getEvents();
        if (eventArray != null) {
            for (int i = 0; i < eventArray.length; ++i) {
                eventArray[i].toXPDL(indentB, theBuffer);
            }
        }
        theBuffer.append(indentA + "</WFEInstruction>\n");
    }

    public void validate(VWSession theSession, Vector EDefVector, VWCompoundStepDefinition myStep) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext, myStep);
    }

    protected void validate(VWValidationContext validationContext, VWCompoundStepDefinition myStep) throws VWException {
        VWValidationError theError;
        VWString theMessage;
        VWValidationError theError2;
        VWString theMessage2;
        int i;
        int errorCount;
        String[] theErrorStrings;
        VWCompiledExpr compRes;
        VWWorkflowSignature myWflSignature = myStep.getMap().getWorkflow().getWorkflowSignature(validationContext);
        VWWorkflowSignature myBaseWflSignature = myStep.getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
        if (this.timeOut != null && this.timeOut.compareTo("") != 0 && this.timeOut.trim().compareTo("0") != 0) {
            compRes = new VWCompiledExpr();
            theErrorStrings = VWExpr.compileVWExpr(this.timeOut, myWflSignature, myBaseWflSignature, null, null, true, compRes);
            errorCount = 0;
            if (theErrorStrings != null) {
                errorCount = theErrorStrings.length;
                for (i = 0; i < errorCount; ++i) {
                    theMessage2 = new VWString("vw.api.VWWFEInstructionTimeOutSyntaxError", "Time Out value: {0}", theErrorStrings[i]);
                    theError2 = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError2);
                }
            } else if (compRes.getResultIsArray() || compRes.getResultType() != 16) {
                VWString theMessage3 = new VWString("vw.api.VWWFEInstructionTimeOutNotTime", "Time Out value expression must be a time expression, found a {0}{1}.", VWFieldType.typeToString(compRes.getResultType()), compRes.getResultIsArray() ? "[ ]" : "");
                VWValidationError theError3 = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(this.action), theMessage3.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError3);
            }
        }
        if (this.timeOut == null || this.timeOut.compareTo("") == 0) {
            theMessage = new VWString("vw.api.VWWFEInstructionTimeOutIsNull", "Time Out value is null or empty");
            theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
            validationContext.addValidationError(theError);
        }
        if (this.eventNumLoc == null || this.eventNumLoc.compareTo("") == 0) {
            theMessage = new VWString("vw.api.VWWFEInstructionEventNumLocIsNull", "eventNumLoc (field name where the triggering event number will be stored) value is null or empty");
            theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
            validationContext.addValidationError(theError);
        }
        if (this.eventNumLoc != null && this.eventNumLoc.compareTo("") != 0) {
            compRes = new VWCompiledRefExpr();
            theErrorStrings = VWExpr.compileVWExpr(":=" + this.eventNumLoc, myWflSignature, myBaseWflSignature, null, null, true, compRes);
            if (theErrorStrings != null) {
                errorCount = theErrorStrings.length;
                for (i = 0; i < errorCount; ++i) {
                    theMessage2 = new VWString("vw.api.VWWFEInstructionEventNumLocSyntaxError", "eventNumLoc (field name where the triggering event number will be stored), {0}, Syntax Error : {1}", this.eventNumLoc, theErrorStrings[i]);
                    theError2 = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(this.action), theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError2);
                }
            } else if (compRes.getResultIsArray() || compRes.getResultType() != 1 && compRes.getResultType() != 8) {
                VWString theMessage4 = new VWString("vw.api.VWWFEInstructionEventNumLocNotNumericLValue", "eventNumLoc (field name where the triggering event number will be stored), {0}, is not a valid numeric LValue", this.eventNumLoc);
                VWValidationError theError4 = new VWValidationError(7, 1, myStep.getName(), VWActionType.getLocalizedString(this.action), theMessage4.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError4);
            }
        }
        if (this.events != null && this.events.length > 0) {
            VWEventDefinition[] e = this.getEvents();
            if (e != null) {
                for (int i2 = 0; i2 < e.length; ++i2) {
                    e[i2].validate(validationContext, myStep, this.instructionId, i2);
                }
            }
        } else {
            theMessage = new VWString("vw.api.VWWFEInstructionNoEvents", "Wait for condition instruction has no events defined");
            theError = new VWValidationError(7, 2, myStep.getName(), VWActionType.getLocalizedString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
            validationContext.addValidationError(theError);
        }
    }

    public String toString() {
        String retVal = "";
        try {
            retVal = VWActionType.typeToString(this.action);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }
}

